unit Beeps;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, registry;

type
  TForm1 = class(TForm)
    MsgBeepParam: TRadioGroup;
    btnMsgBeep: TButton;
    btnPlayWAVSound: TButton;
    OpenDialog1: TOpenDialog;
    chkLoop: TCheckBox;
    btnPlaySystemSound: TButton;
    GroupBox1: TGroupBox;
    btnBeep: TButton;
    cmbSystemSound: TComboBox;
    btnKilepes: TButton;
    Label1: TLabel;
    procedure btnMsgBeepClick(Sender: TObject);
    procedure btnPlayWAVSoundClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure btnPlaySystemSoundClick(Sender: TObject);
    procedure btnBeepClick(Sender: TObject);
    procedure btnKilepesClick(Sender: TObject);
  private
    { Private declarations }
    procedure Read_Registry;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
 uses MMSystem;
{$R *.DFM}

procedure TForm1.btnMsgBeepClick(Sender: TObject);
var
  param: integer;
begin
  PlaySound(nil, 0, SND_PURGE);   // hanglejtszs lelltsa
  param:=0;                       // vltoz-inicializls
  case MsgBeepParam.ItemIndex of  // ha a bejellt rdigomb sorszma egyenl a(z)...
    0: param:=0;
    1: param:=MB_ICONASTERISK;
    2: param:=MB_ICONEXCLAMATION;
    3: param:=MB_ICONHAND;
    4: param:=MB_ICONQUESTION;
    5: param:=MB_OK;
  end;
  MessageBeep(param);     // hanglejtszs
end;

procedure TForm1.btnPlayWAVSoundClick(Sender: TObject);
begin
  if OpenDialog1.Execute then   // ha kivlasztottunk egy fjlt
    begin
      PlaySound(nil,0,SND_PURGE);  // hanglejtszs lelltsa
      if chkLoop.State = cbChecked then    // ha be van jellve a "Folyamatos lejtszs" jellngyzet
        PlaySound(PChar(OpenDialog1.FileName),0,SND_FILENAME or SND_ASYNC or SND_LOOP)
      else   // ha nincs bejellve a "Folyamatos lejtszs" jellngyzet
        PlaySound(PChar(OpenDialog1.FileName),0,SND_FILENAME or SND_ASYNC);
    end;
end;

procedure TForm1.Read_Registry;
var
  Reg: TRegIniFile;
begin
  Reg:=TRegIniFile.Create;
  try
    Reg.RootKey:=HKEY_CURRENT_USER;
    if Reg.OpenKey('AppEvents\EventLabels', False) then
       Reg.ReadSections(cmbSystemSound.Items);
  finally
    Reg.Free;
  end;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  PlaySound(nil,0,SND_PURGE);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  OpenDialog1.InitialDir:=GetCurrentDir;
  cmbSystemSound.Items.Clear;
  Read_Registry;
end;

procedure TForm1.btnPlaySystemSoundClick(Sender: TObject);
begin
  PlaySound(nil, 0, SND_PURGE);
  PlaySound(PChar(cmbSystemSound.Text), 0, SND_ALIAS or SND_ASYNC);
end;

procedure TForm1.btnBeepClick(Sender: TObject);
begin
  PlaySound(nil, 0, SND_PURGE);
  Beep;   // hanglejtszs, ua., mint a MessageBeep(0);
end;

procedure TForm1.btnKilepesClick(Sender: TObject);
begin
  Close;
end;

end.
